package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.ImageIcon;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.Color;
import java.awt.FlowLayout;
import net.miginfocom.swing.MigLayout;
import javax.swing.JComboBox;

public class MainAppWindow {

	private JFrame frmExpectingToFly;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centerPanel;
	private JLabel lblExpectingToFly;
	private JLabel lblNewLabel;
	private JComboBox comboBox;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmExpectingToFly.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmExpectingToFly = new JFrame();
		frmExpectingToFly.setTitle("Expecting to Fly");
		frmExpectingToFly.setBounds(200, 100, 450, 300);
		frmExpectingToFly.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmExpectingToFly.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmExpectingToFly.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmExpectingToFly.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmExpectingToFly.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmExpectingToFly.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
	}
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			FlowLayout flowLayout = (FlowLayout) northPanel.getLayout();
			northPanel.add(getLblExpectingToFly());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
		}
		return southPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setLayout(new MigLayout("", "[][][][grow][][]", "[][][][]"));
			centerPanel.add(getLblNewLabel(), "cell 0 0");
			centerPanel.add(getComboBox(), "cell 3 1 2 2,growx");
		}
		return centerPanel;
	}
	private JLabel getLblExpectingToFly() {
		if (lblExpectingToFly == null) {
			lblExpectingToFly = new JLabel("Expecting to Fly");
			lblExpectingToFly.setForeground(Color.BLUE);
			lblExpectingToFly.setFont(new Font("Tahoma", Font.BOLD, 16));
		}
		return lblExpectingToFly;
	}
	private JLabel getLblNewLabel() {
		if (lblNewLabel == null) {
			lblNewLabel = new JLabel("New label");
		}
		return lblNewLabel;
	}
	private JComboBox getComboBox() {
		if (comboBox == null) {
			comboBox = new JComboBox();
		}
		return comboBox;
	}
}
